#!/bin/sh

# reload random seed at startup.
# it will be saved on disk when the user turns off the power switch
# to carry entropy pool information across shutdowns and startups.

random_seed=/var/lib/random-seed
if [ -f $random_seed ]; then
    cat $random_seed > /dev/urandom
else
    touch $random_seed
fi
chmod 600 $random_seed

dd if=/dev/urandom of=$random_seed count=1 bs=512 2>/dev/null
sync

