#!/bin/sh
chown 500.500 mnt/korg/rw/HD
chmod 555 mnt/korg/ftp
if [ ! -e /korg/rw/Startup/KronosNet.conf ]; then
	echo "nautilus
nautilus
" > /korg/rw/Startup/KronosNet.conf
fi

numberOfFilesToVerify=0
while read line
do
	let "numberOfFilesToVerify = numberOfFilesToVerify + 1"
done < NAUTILUS_Update_1_3_5.csum
echo "number of files to verify is $numberOfFilesToVerify" >> /tmp/updater_error
fpProgressBarIncrementPerFile=$(echo "scale=4; 100.0 / $numberOfFilesToVerify" | /mnt/updaterSource/bc -q 2>/dev/null)
/mnt/updaterSource/DisplayUpdaterMessage "Verifying Installed Files..."
/mnt/updaterSource/DisplayUpdaterMessage "SetDefaultPalette"
echo "set 0" > /proc/OmapNKS4ProgressBar
fpProgress=0.0
progress=0
checksumErrorFound=0
while read line
do
	fileName=`echo "$line" | awk '{ print $1 }'`
	refchecksum=`echo "$line" | awk '{ print $2 }'`
	checksum=`/mnt/updaterSource/md5sum $fileName | awk '{ print $1 }'`
	if [ "$checksum" != "$refchecksum" ]; then
		echo "Checksum failure for $fileName" >> /tmp/updater_error
		let "checksumErrorFound = checksumErrorFound + 1"
	fi
	fpProgress=$(echo "scale=4; $fpProgress + $fpProgressBarIncrementPerFile" | /mnt/updaterSource/bc -q 2>/dev/null)
	newProgress=$(echo "($fpProgress+0.5)/1" | /mnt/updaterSource/bc -q 2>/dev/null)
	if [ $progress != $newProgress ]; then
		progress=$newProgress
		echo "set $progress" > /proc/OmapNKS4ProgressBar
		echo "updated progress bar with $progress" >> /tmp/updater_error
	fi
done < NAUTILUS_Update_1_3_5.csum
if [ $checksumErrorFound -ne 0 ]; then
	kill -9 $(/sbin/pidof UpdateOS)
	/mnt/updaterSource/DisplayUpdaterMessage "Checksum Error! Update failed, recovery may require format and full install."
	echo "$checksumErrorFound installed files had checksum errors" >> /tmp/updater_error
	exit 1
else
	echo "No checksum errors found" >> /tmp/updater_error
fi
/mnt/updaterSource/DisplayUpdaterMessage "Finishing Installation..."
/mnt/updaterSource/DisplayUpdaterMessage "SetDefaultPalette"
echo "set 0" > /proc/OmapNKS4ProgressBar
sync
progress=6
for seconds in {1..15}; do
	echo "set $progress" > /proc/OmapNKS4ProgressBar
	sleep 1
	let "progress = progress + 6"
done
echo "set 100" > /proc/OmapNKS4ProgressBar
/mnt/updaterSource/DisplayUpdaterMessage "SetTextPalette"
/usr/local/bin/ssdutil --fwupdate /dev/sda
if [ $? -ne 0 ]; then
	kill -9 $(/sbin/pidof UpdateOS)
	/mnt/updaterSource/DisplayUpdaterMessage "SSD Firmware Update Error! Update failed."
	echo "SSD firmware update error" >> /tmp/updater_error
	exit 1
fi


